<?php

namespace Fusionalliance\Controlforms;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FormSubmission extends Model 
{

    protected $table = 'form_submissions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function controlForm()
    {
        return $this->belongsTo('ControlForm');
    }

    public function formUser()
    {
        return $this->belongsTo('FormUser');
    }

    public function formValues()
    {
        return $this->hasMany('FormValue');
    }

    public function formMetaFieldValues()
    {
        return $this->hasMany('FormMetaFieldValue');
    }

    public function formMetaFields()
    {
        return $this->hasManyThrough('FormMetaField', 'FormMetaFieldValue');
    }

}